-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versión del servidor:         10.4.8-MariaDB - mariadb.org binary distribution
-- SO del servidor:              Win64
-- HeidiSQL Versión:             11.0.0.5919
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Volcando estructura para tabla calidadcliente.encuestas
CREATE TABLE IF NOT EXISTS `encuestas` (
  `id_encuesta` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(50) NOT NULL,
  `titulo` text NOT NULL DEFAULT '',
  `intro` text NOT NULL DEFAULT '',
  `activo` int(1) NOT NULL DEFAULT 0,
  `fecha` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_encuesta`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.encuestas: ~2 rows (aproximadamente)
DELETE FROM `encuestas`;
/*!40000 ALTER TABLE `encuestas` DISABLE KEYS */;
INSERT INTO `encuestas` (`id_encuesta`, `nombre`, `titulo`, `intro`, `activo`, `fecha`) VALUES
	(1, 'general', '{"es":"Encuesta de satisfacción","en": "Satisfaction survey","br": "Pesquisa de satisfação","pt": "Pesquisa de satisfação"}', '{"es": "Valore del 1 al 10 los siguientes aspectos siendo 1 la puntuación más baja y 10 la más alta","en": "Rate the following aspects from 1 to 10, with 1 being the lowest and 10 the highest.","br": "Classifique os seguintes aspectos de 1 a 10, sendo 1 a pontuação mais baixa e 10 a mais alta","pt": "Classifique os seguintes aspectos de 1 a 10, sendo 1 a pontuação mais baixa e 10 a mais alta"}', 1, '2022-06-24 11:29:46'),
	(2, 'autoevaluacion', '{"es":"Autoevaluación de satisfacción cliente","en": "Customer satisfaction self-assessment","br": "Autoavaliação da satisfação do cliente","pt": "Autoavaliação da satisfação do cliente"}', '{"es":"Valore los siguientes aspectos","en":"Evaluate the following aspects","br":"Avalie os seguintes aspectos","pt":"Avalie os seguintes aspectos"}', 1, '2022-06-24 11:30:27');
/*!40000 ALTER TABLE `encuestas` ENABLE KEYS */;

-- Volcando estructura para tabla calidadcliente.encuestas_preguntas
CREATE TABLE IF NOT EXISTS `encuestas_preguntas` (
  `id_encuesta_pregunta` int(11) NOT NULL AUTO_INCREMENT,
  `id_encuesta` int(11) DEFAULT NULL,
  `id_pregunta` int(11) DEFAULT NULL,
  `orden` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_encuesta_pregunta`),
  KEY `FK_encuesta` (`id_encuesta`),
  KEY `FK_pregunta` (`id_pregunta`),
  CONSTRAINT `FK_encuesta` FOREIGN KEY (`id_encuesta`) REFERENCES `encuestas` (`id_encuesta`),
  CONSTRAINT `FK_pregunta` FOREIGN KEY (`id_pregunta`) REFERENCES `preguntas` (`id_pregunta`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.encuestas_preguntas: ~44 rows (aproximadamente)
DELETE FROM `encuestas_preguntas`;
/*!40000 ALTER TABLE `encuestas_preguntas` DISABLE KEYS */;
INSERT INTO `encuestas_preguntas` (`id_encuesta_pregunta`, `id_encuesta`, `id_pregunta`, `orden`) VALUES
	(1, 2, 1, 2),
	(2, 2, 2, 3),
	(3, 2, 3, 4),
	(4, 2, 4, 5),
	(5, 2, 5, 7),
	(6, 2, 6, 8),
	(7, 2, 7, 9),
	(8, 2, 8, 10),
	(9, 2, 9, 11),
	(10, 2, 10, 12),
	(11, 2, 11, 13),
	(12, 2, 12, 15),
	(13, 2, 13, 16),
	(14, 2, 14, 17),
	(15, 2, 15, 18),
	(16, 2, 16, 19),
	(17, 2, 17, 20),
	(18, 2, 18, 22),
	(19, 2, 19, 23),
	(20, 2, 20, 24),
	(21, 2, 21, 1),
	(22, 2, 22, 6),
	(23, 2, 23, 14),
	(24, 2, 24, 21),
	(25, 1, 25, 1),
	(26, 1, 26, 2),
	(27, 1, 27, 3),
	(28, 1, 28, 4),
	(29, 1, 29, 5),
	(30, 1, 30, 6),
	(31, 1, 31, 7),
	(32, 1, 32, 8),
	(33, 1, 33, 9),
	(34, 1, 34, 10),
	(35, 1, 35, 11),
	(36, 1, 36, 12),
	(37, 1, 37, 13),
	(38, 1, 38, 14),
	(39, 1, 39, 15),
	(40, 1, 40, 16),
	(41, 1, 41, 17),
	(42, 1, 42, 18),
	(43, 1, 43, 19),
	(44, 1, 44, 20);
/*!40000 ALTER TABLE `encuestas_preguntas` ENABLE KEYS */;

-- Volcando estructura para tabla calidadcliente.encuestas_proyectos
CREATE TABLE IF NOT EXISTS `encuestas_proyectos` (
  `id_encuesta_proyecto` int(11) NOT NULL AUTO_INCREMENT,
  `id_encuesta` int(11) NOT NULL,
  `id_proyecto_sugar` varchar(50) NOT NULL,
  `fecha` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id_encuesta_proyecto`),
  KEY `FK_encuesta_proyecto` (`id_encuesta`),
  CONSTRAINT `FK_encuesta_proyecto` FOREIGN KEY (`id_encuesta`) REFERENCES `encuestas` (`id_encuesta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.encuestas_proyectos: ~0 rows (aproximadamente)
DELETE FROM `encuestas_proyectos`;
/*!40000 ALTER TABLE `encuestas_proyectos` DISABLE KEYS */;
/*!40000 ALTER TABLE `encuestas_proyectos` ENABLE KEYS */;

-- Volcando estructura para tabla calidadcliente.encuestas_respuestas
CREATE TABLE IF NOT EXISTS `encuestas_respuestas` (
  `id_encuesta_respuesta` int(11) NOT NULL AUTO_INCREMENT,
  `id_encuesta_proyecto` int(11) NOT NULL,
  `id_encuesta_pregunta` int(11) NOT NULL,
  `respuesta` text NOT NULL,
  PRIMARY KEY (`id_encuesta_respuesta`),
  KEY `FK_proyecto_encuesta` (`id_encuesta_proyecto`),
  KEY `FK_encuesta_pregunta` (`id_encuesta_pregunta`),
  CONSTRAINT `FK_encuesta_pregunta` FOREIGN KEY (`id_encuesta_pregunta`) REFERENCES `encuestas_preguntas` (`id_encuesta_pregunta`),
  CONSTRAINT `FK_proyecto_encuesta` FOREIGN KEY (`id_encuesta_proyecto`) REFERENCES `encuestas_proyectos` (`id_encuesta_proyecto`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.encuestas_respuestas: ~0 rows (aproximadamente)
DELETE FROM `encuestas_respuestas`;
/*!40000 ALTER TABLE `encuestas_respuestas` DISABLE KEYS */;
/*!40000 ALTER TABLE `encuestas_respuestas` ENABLE KEYS */;

-- Volcando estructura para tabla calidadcliente.preguntas
CREATE TABLE IF NOT EXISTS `preguntas` (
  `id_pregunta` int(11) NOT NULL AUTO_INCREMENT,
  `texto` text DEFAULT NULL,
  `tipo_respuesta` varchar(50) DEFAULT NULL COMMENT 'comentario / selector / decimal / cabecera / separador',
  PRIMARY KEY (`id_pregunta`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.preguntas: ~44 rows (aproximadamente)
DELETE FROM `preguntas`;
/*!40000 ALTER TABLE `preguntas` DISABLE KEYS */;
INSERT INTO `preguntas` (`id_pregunta`, `texto`, `tipo_respuesta`) VALUES
	(1, '{"es":"¿Cuál es el grado de cumplimiento de los objetivos / KPIs acordados?"}', 'selector'),
	(2, '{"es":"¿Conoce la alta dirección del cliente los resultados del trabajo?"}', 'selector'),
	(3, '{"es":"¿Hemos ayudado a nuestro principal interlocutor a poner en valor internamente su trabajo?"}', 'selector'),
	(4, '{"es":"Explica qué hemos hecho"}', 'comentario'),
	(5, '{"es":"¿Ha expresado formalmente el cliente su satisfacción con nuestro trabajo?"}', 'selector'),
	(6, '{"es":"¿Se ha producido alguna queja o conflicto con el cliente?"}', 'selector'),
	(7, '{"es":"Indica el caso y la situación en que se encuentra"}', 'comentario'),
	(8, '{"es":"¿Ha valorado el cliente específicamente la creatividad de nuestras propuestas?"}', 'selector'),
	(9, '{"es":"¿Se han producido en el equipo movimientos que hayan afectado negativamente al trabajo con el cliente?"}', 'selector'),
	(10, '{"es":"¿Ha habido períodos prolongados de falta de interacción con el cliente?"}', 'selector'),
	(11, '{"es":"En caso de que hayan exisitido, indica los motivos"}', 'comentario'),
	(12, '{"es":"¿Hemos involucrado al cliente en iniciativas de LLYC (artículos, eventos, task force, encuentros…)?"}', 'selector'),
	(13, '{"es":"¿Se han celebrado reuniones del cliente con la alta dirección de LLYC (CEO, DG)?"}', 'selector'),
	(14, '{"es":"En caso de respuesta negativa en las dos preguntas anteriores, argumenta tu respuesta"}', 'comentario'),
	(15, '{"es":"¿Hemos presentado al cliente otras áreas, soluciones o servicios de LLYC diferentes a los contratados?"}', 'selector'),
	(16, '{"es":"En caso de respuesta negativa, explica las razones"}', 'comentario'),
	(17, '{"es":"¿Conoce el cliente nuestras soluciones basadas en tecnología?"}', 'selector'),
	(18, '{"es":"¿Cuál es nuestro nivel real de dedicación al cliente respecto a lo contratado?"}', 'selector'),
	(19, '{"es":"En caso de over o under service ¿Se ha pactado al cliente alguna medida para subsanarlo?"}', 'selector'),
	(20, '{"es":"Si ha solicitado el cliente servicios adicionales no incluidos en los honorarios ¿cómo se ha resuelto?"}', 'selector'),
	(21, '{"es":"Evaluación de los resultados del trabajo para el cliente"}', 'cabecera'),
	(22, '{"es":"Valoración de la satisfacción del cliente"}', 'cabecera'),
	(23, '{"es":"Valoración de la interacción del cliente con LLYC"}', 'cabecera'),
	(24, '{"es":"Gestión de la cuenta"}', 'cabecera'),
	(25, '{"es":"Equipo de LLYC"}', 'cabecera'),
	(26, '{"es":"Su estabilidad y su impacto en el servicio"}', 'decimal'),
	(27, '{"es":"La implicación de profesionales más senior en el trabajo"}', 'decimal'),
	(28, '{"es":"Su experiencia en la gestión y su capacidad de resolución"}', 'decimal'),
	(29, '{"es":"Su conocimiento del negocio y el sector"}', 'decimal'),
	(30, '{"es":"Aportación"}', 'cabecera'),
	(31, '{"es":"Proactividad: agilidad para la anticipación y recomendación"}', 'decimal'),
	(32, '{"es":"Creatividad: originalidad de enfoques y contenidos"}', 'decimal'),
	(33, '{"es":"Estrategia: planteamiento y planificación"}', 'decimal'),
	(34, '{"es":"Flexibilidad: adaptación a las necesidades del cliente"}', 'decimal'),
	(35, '{"es":"Relacionamiento: nivel de acceso a stakeholders clave"}', 'decimal'),
	(36, '{"es":"Tecnología: aplicación en los procesos de trabajo"}', 'decimal'),
	(37, '{"es":"Resultados"}', 'cabecera'),
	(38, '{"es":"Cumplimiento global de los objetivos propuestos"}', 'decimal'),
	(39, '{"es":"Cumplimiento de los KPIs definidos"}', 'decimal'),
	(40, '{"es":"Valor del trabajo de LLYC para el área del cliente"}', 'decimal'),
	(41, '{"es":"Valor del trabajo de LLYC para el negocio"}', 'decimal'),
	(42, '{"es":""}', 'separador'),
	(43, '{"es":"En una escala del 1 al 10 ¿en qué punto situaría su interés por prescribir a LLYC a terceros?"}', 'decimal'),
	(44, '{"es":"¿Qué le lleva a esa consideración respecto a LLYC?"}', 'comentario');
/*!40000 ALTER TABLE `preguntas` ENABLE KEYS */;

-- Volcando estructura para tabla calidadcliente.respuestas
CREATE TABLE IF NOT EXISTS `respuestas` (
  `id_respuesta` int(11) NOT NULL AUTO_INCREMENT,
  `id_pregunta` int(11) NOT NULL DEFAULT 0,
  `valor` text NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_respuesta`),
  KEY `FK_pregunta_respuesta` (`id_pregunta`),
  CONSTRAINT `FK_pregunta_respuesta` FOREIGN KEY (`id_pregunta`) REFERENCES `preguntas` (`id_pregunta`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4;

-- Volcando datos para la tabla calidadcliente.respuestas: ~40 rows (aproximadamente)
DELETE FROM `respuestas`;
/*!40000 ALTER TABLE `respuestas` DISABLE KEYS */;
INSERT INTO `respuestas` (`id_respuesta`, `id_pregunta`, `valor`) VALUES
	(1, 1, '{"es":"Alto"}'),
	(2, 1, '{"es":"Medio"}'),
	(3, 1, '{"es":"Bajo"}'),
	(4, 1, '{"es":"No hay KPIs"}'),
	(5, 2, '{"es":"Por LLYC"}'),
	(6, 2, '{"es":"Por equipo cliente"}'),
	(7, 2, '{"es":"No conoce"}'),
	(8, 3, '{"es":"Sí"}'),
	(9, 3, '{"es":"No"}'),
	(10, 5, '{"es":"Sí"}'),
	(11, 5, '{"es":"No"}'),
	(12, 6, '{"es":"Sí"}'),
	(13, 6, '{"es":"No"}'),
	(14, 8, '{"es":"Sí"}'),
	(15, 8, '{"es":"No"}'),
	(16, 8, '{"es":"Ha criticado"}'),
	(17, 9, '{"es":"Sí"}'),
	(18, 9, '{"es":"No"}'),
	(19, 10, '{"es":"Sí"}'),
	(20, 10, '{"es":"No"}'),
	(21, 12, '{"es":"Sí"}'),
	(22, 12, '{"es":"No"}'),
	(23, 13, '{"es":"Sí"}'),
	(24, 13, '{"es":"No"}'),
	(25, 15, '{"es":"Sí"}'),
	(26, 15, '{"es":"No"}'),
	(27, 17, '{"es":"Sí"}'),
	(28, 17, '{"es":"No"}'),
	(29, 18, '{"es":"Acorde"}'),
	(30, 18, '{"es":"Overservice"}'),
	(31, 18, '{"es":"Underservice"}'),
	(32, 19, '{"es":"Ajuste de honorarios"}'),
	(33, 19, '{"es":"Ajuste de actividad"}'),
	(34, 19, '{"es":"Cambios de equipo"}'),
	(35, 19, '{"es":"No"}'),
	(36, 19, '{"es":"No aplica"}'),
	(37, 20, '{"es":"Acuerdo"}'),
	(38, 20, '{"es":"LLYC deniega"}'),
	(39, 20, '{"es":"Cliente rechaza"}'),
	(40, 20, '{"es":"No solicita"}');
/*!40000 ALTER TABLE `respuestas` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
