<?php
namespace App\Http\Connection;

use Illuminate\Support\Facades\Storage;
use Google\Cloud\BigQuery\BigQueryClient;


class ConnBigQuery{

    private $projectId;
	private $serviceAccountPath;
	private $datasetId;
	
	function __construct() {
		$this->projectId = env('BIGQUERY_PROJECTID');
		$this->serviceAccountPath = Storage::path(env('BIGQUERY_CONFIG'));         
		$this->datasetId = env('BIGQUERY_DATASETID'); 
	}

    /**
	 * Insertar en una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param array $data					Estructura de datos a insertar
	 */	

	function insertar($tableId, $data){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		$dataset = $bigQuery->dataset($this->datasetId);
		$table = $dataset->table($tableId);

        try {
				
            $insertResponse = $table->insertRows($data);

            if ($insertResponse->isSuccessful()) {
                /*
                print('Data streamed into BigQuery successfully' . PHP_EOL);
                echo 'tableId == ' . $tableId . '<pre>';
                print_r($data);
                echo '</pre>';
                */

                return true;
            } else {
                foreach ($insertResponse->failedRows() as $row) {
                    foreach ($row['errors'] as $error) {
                        printf('%s: %s' . PHP_EOL, $error['reason'], $error['message']);
                    }
                }
                return false;
            }
        } catch (\Exception $e) {
            /*
            DB::rollback();
            throw $e;
            */
            return false;
        }
	}

    /**
	 * Cargar un csv en una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param array $url_csv				URL del fichero csv
	 */	
	function load($tableId, $url_csv){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		$dataset = $bigQuery->dataset($this->datasetId);
		$table = $dataset->table($tableId);

		
		// Begin a job to import data from a CSV file into the table.
		$loadJobConfig = $table->load(fopen($url_csv, 'r'));
				
		$job = $table->runJob($loadJobConfig);

		
		echo 'tableId == ' . $tableId . '<pre>';
		print_r($job);
		echo '</pre><br>';
		
		
/*
		if ($insertResponse->isSuccessful()) {
			print('Data streamed into BigQuery successfully' . PHP_EOL);
			echo 'tableId == ' . $tableId . '<pre>';
			print_r($data);
			echo '</pre>';
			return true;
		} else {
			foreach ($insertResponse->failedRows() as $row) {
				foreach ($row['errors'] as $error) {
					printf('%s: %s' . PHP_EOL, $error['reason'], $error['message']);
				}
			}
			return false;
		}*/
	}


	
	/**
	 * Obtener datos de una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param string $querysql				String query SQL
	 */	

	function getdata($querysql){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		// Run a query and inspect the results.
		$queryJobConfig = $bigQuery->query(
			$querysql
		);
		$queryResults = $bigQuery->runQuery($queryJobConfig);


		if ($queryResults->isComplete()) {

			$rows = $queryResults->rows();
			/*
			$i= 0;
			foreach ($rows as $row) {
				printf('--- Row %s ---' . PHP_EOL, ++$i);
				print_r($row);
				echo "<br>";
			}
			printf('Found %s row(s)' . PHP_EOL, $i);
			*/

			return $rows;
		} else {
			throw new Exception('The query failed to complete');
		}
	}


	/**
	 * Borrar los datos de una tabla.
	 *
	 * @param string $tableId           	Identificador de la tabla.
	 * @param string $querysql				String query SQL
	 */	

	function deletedata($tableId, $querysql){

		// instantiate the bigquery table service
		$bigQuery = new BigQueryClient([
			'projectId' => $this->projectId,
			'keyFilePath' => $this->serviceAccountPath,
		]);

		
		$dataset = $bigQuery->dataset($this->datasetId);
		$table = $dataset->table($tableId);


		// Run a query and inspect the results.
		$queryJobConfig = $bigQuery->query(
			$querysql
		);
		$queryResults = $bigQuery->runQuery($queryJobConfig);


		if ($queryResults->isComplete()) {

			$rows = $queryResults->rows();
			/*
			$i= 0;
			foreach ($rows as $row) {
				printf('--- Row %s ---' . PHP_EOL, ++$i);
				print_r($row);
				echo "<br>";
			}
			printf('Found %s row(s)' . PHP_EOL, $i);
			*/

			return $rows;
		} else {
			throw new Exception('The query failed to complete');
		}
	}
}
?>