<?php

namespace App\Http\Controllers;

use App\Models\Encuesta;
use App\Models\EncuestasProyectos;
use App\Models\EncuestasPreguntas;
use App\Models\EncuestasRespuestas;

use App\Http\Connection\ConnBigQuery;


use App\Http\Requests\StoreEncuestaRequest;
use App\Http\Requests\UpdateEncuestaRequest;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

use Log;


class EncuestaController extends Controller
{
    private $idioma = 'es';
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $data = request()->except('_token');
        if(!empty($data['cid']) && !empty($data['tp']) ){
            
            $data['tipo_encuesta'] =  strip_tags($data['tp']);
            $data['client_id'] =  strip_tags($data['cid']);
            if(!empty($data['lang'])){
                $this->idioma = strip_tags($data['lang']);
            }
            if(!empty($data['view'])){
                if (strip_tags($_GET['view']) == 1){
                    $data['ver_resultados'] = true;
                }
            }
            $data['idioma'] = $this->idioma;


            $encuestasModel = new Encuesta(); 
            $encuesta = $encuestasModel->getEncuesta($data['tipo_encuesta']);
            if(empty($encuesta)){
                
                Log::error('ENCUESTA: ' . $data['tipo_encuesta'] . ' - CLIENTE: ' . $data['client_id'] . ' -- NO ENCONTRADA --');
                $data['mensaje'] = array(
                    'es' => "No encontramos la encuesta que busca.",
                    'en' => "We did not find the survey you are looking for.",
                    'br' => "Não encontramos a pesquisa que você está procurando.",
                    'pt' => "Não encontramos a pesquisa que você está procurando.",
                  );
                header('HTTP/1.0 404 Not Found', true, 404);
                return view('not-found', $data);	

            } else {
                /*
                echo "<pre>";
                    print_r($encuesta);            
                echo "</pre>";
                */
                
                $data['encuesta'] = $encuesta;


                $encuestasProyectosModel = new EncuestasProyectos();
                $encuestaProyecto = $encuestasProyectosModel->getEncuestaProyecto($encuesta['id_encuesta'], $data['client_id']);
                                
                if(!empty($encuestaProyecto)){
                    // La encuesta ya ha sido contestada
                    $is_completed = true;
                    if(!empty($data['ver_resultados'])){
                        Log::info('ENCUESTA: ' . $data['tipo_encuesta'] . ' - CLIENTE: ' . $data['client_id']. ' -- VER RESULTADOS --');

                        // Sacamos las preguntas y su respuesta
                        // --------------------------------------------
                        $encuestasPreguntasModel = new EncuestasPreguntas();
                        $encuestaPreguntas = $encuestasPreguntasModel->getEncuestasPreguntasRespuestas($encuesta['id_encuesta'], $encuestaProyecto['id_encuesta_proyecto']);
                        $data['preguntas'] = $encuestaPreguntas;

                    } else {
                        
                        Log::info('ENCUESTA: ' . $data['tipo_encuesta'] . ' - CLIENTE: ' . $data['client_id']. ' -- YA COMPLETADA --');

                        $data['mensaje'] = array(
                            'es' => "La encuesta ya está completada",
                            'en' => "The survey is already completed",
                            'br' => "A pesquisa já está concluída",
                            'pt' => "A pesquisa já está concluída",
                        );	
                        return view('is-completed', $data);	                        
                    }
                } else {
                    // La encuesta debe completarse
                    if(!empty($data['ver_resultados'])){
                        
                        Log::info('ENCUESTA: ' . $data['tipo_encuesta'] . ' - CLIENTE: ' . $data['client_id'] . ' -- NO RESPONDIDA --');

                        $data['mensaje'] = array(
                            'es' => "Ups! La encuesta aún no está respondida",
                            'en' => "Oops! The survey is not answered yet",
                            'br' => "Opa! A pesquisa ainda não foi respondida",
                            'pt' => "Opa! A pesquisa ainda não foi respondida",
                          );
                        return view('pages-error', $data);	 

                    } else {
                        
                        Log::info('ENCUESTA: ' . $data['tipo_encuesta'] . ' - CLIENTE: ' . $data['client_id'] . ' -- ACCESO --');
                        // Sacamos las preguntas de la encuesta
                        // --------------------------------------------
                        $encuestasPreguntasModel = new EncuestasPreguntas();
                        $encuestaPreguntas = $encuestasPreguntasModel->getEncuestasPreguntasOpciones($encuesta['id_encuesta']);
                        $data['preguntas'] = $encuestaPreguntas;
                    }

                }

                return view('encuesta', $data);
            }            
        } else {


            Log::error('ACCESO SIN PARAMENTROS');

            header('HTTP/1.0 400 Bad Request', true, 400);

            $mensaje= array(
            'es' => 'Los parámetros recibidos no son correctos.',
            );   
            $data['mensaje'] =  $mensaje;
            $data['idioma'] = $this->idioma;
            return view('pages-error', $data);
        }
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        //
        $data = request()->except('_token');

        $fields = [
            'cid' => 'required|string',
            'id_encuesta' => 'required|integer',
            'idioma' => 'required|string',
            //'correo' => 'required|email',
            //'telefono' => 'required|integer',
        ];

        
        // Sacamos las preguntas de la encuesta obligatorias
        $encuestasPreguntasModel = new EncuestasPreguntas();
        $encuestaPreguntasReq = $encuestasPreguntasModel->getEncuestasPreguntasObligatorias($data['id_encuesta']);

        foreach($encuestaPreguntasReq as $pregunta){
            $fields['preg_' . $pregunta['id_encuesta_pregunta']] = 'required|string';
        }


        $message = [
            'required' => ':attribute is required'
        ];

        $this->validate($request, $fields, $message);
/*
        $connBigQuery = new ConnBigQuery();
        die();
  */      
        if(!empty($data['cid']) && !empty($data['id_encuesta']) ){


            $data['client_id'] =  strip_tags($data['cid']);
            $data['idioma'] =  strip_tags($data['idioma']);

            $this->idioma = $data['idioma'];

            $encuestaModel = new Encuesta();
            $encuesta = $encuestaModel->getEncuestabyId($data['id_encuesta']);

            Log::info('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- ENVIO --');

            
            // Sacamos las preguntas de la encuesta
            $encuestaPreguntas = $encuestasPreguntasModel->getEncuestasPreguntas($data['id_encuesta']);

            // Comenzamos la transaccion
            DB::beginTransaction();

            // Insertar en encuestas_proyectos
            $encuestasProyectosModel = new EncuestasProyectos();
            $encuestaProyectoID = $encuestasProyectosModel->insertEncuestaProyecto($data['id_encuesta'], $data['client_id']);
            // END - Insertar en encuestas_proyectos

            if($encuestaProyectoID){

                Log::info('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- GUARDADO EncuestasProyectos --');
                        
                // Insertar en encuestas_respuestas
                $data_insert = array();
                foreach($encuestaPreguntas as $pregunta){
                    if(!empty($data['preg_' . $pregunta['id_encuesta_pregunta']])){
                        $respuesta_cliente = strip_tags($data['preg_' . $pregunta['id_encuesta_pregunta']]);
                        $data_insert[]=array(
                            'id_encuesta_proyecto' => $encuestaProyectoID,
                            'id_encuesta_pregunta' => $pregunta['id_encuesta_pregunta'],
                            'respuesta' => $respuesta_cliente
                        );
                    }
                }
                
                $encuestasRespuestasModel = new EncuestasRespuestas();
                $response = $encuestasRespuestasModel->insertEncuestasRespuestas($data_insert);
                // END - Insertar en encuestas_proyectos

                if(!empty($response) == true){
                    Log::info('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- GUARDADO EncuestasRespuestas --');

                    // Insertar en BIGQUERY
                    $tabla_bigquery = "Encuesta_" . $encuesta['nombre'];

                    $data_big_query = array(
                        'proyecto_sugar' => $data['client_id'],
                        'fecha' => time(),
                    );
                    $num_pregunta = 1;
                    foreach($encuestaPreguntas as $pregunta){
                        if(in_array($pregunta['tipo_respuesta'], ['decimal','selector','comentario']) ){
                            $data_big_query['pregunta_' . $num_pregunta] = json_decode($pregunta['texto'], true)['es'] ;
                            if(!empty($data['preg_' . $pregunta['id_encuesta_pregunta']])){
                                $respuesta_cliente = strip_tags($data['preg_' . $pregunta['id_encuesta_pregunta']]);
                            } else {
                                $respuesta_cliente = '';
                            }
                            $data_big_query['respuesta_' . $num_pregunta] =  $respuesta_cliente;
                            $num_pregunta++;
                        }
                    }
                    
                    $data_BQ[] = array(
                        'data' => $data_big_query
                    );

                    $connBigQuery = new ConnBigQuery();            
                    $responseBQ = $connBigQuery->insertar($tabla_bigquery, $data_BQ);
                    // END - Insertar en BIGQUERY
                } else {
                    Log::error('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- ERROR GUARDADO EncuestasRespuestas --');
                }
            } else {                
                Log::error('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- ERROR GUARDADO EncuestasProyectos --');
            }

            
            if(!empty($responseBQ) == true){   
                // Confirmamos la transaccion                     
                DB::commit();	

                Log::info('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- GUARDADO BigQuery --');                
                Log::info('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- GUARDADO OK --');


                $mensaje = array(
                    'es' => "Gracias por completar la encuesta",
                    'en' => "Thank you for completing the survey",
                    'br' => "Obrigado por completar a pesquisa",
                    'pt' => "Obrigado por completar a pesquisa",
                );

                $data['mensaje'] =  $mensaje;
                return view('thankyou-page', $data);
            } else {        
                // Se ha generado un error revertimos la transaccion        
                DB::rollback();

                Log::error('ENCUESTA: ' . $encuesta['nombre'] . ' - CLIENTE: ' . $data['client_id'] . ' -- ERROR GUARDADO BigQuery --');  
                $mensaje = array(
                    'es' => "Ups! hemos tenido un problema. Inténtelo de nuevo más tarde",
                    'en' => "Oops! we have had a problem. Try it again later",
                    'br' => "Opa! tivemos um problema. Tente novamente mais tarde",
                    'pt' => "Opa! tivemos um problema. Tente novamente mais tarde",
                );
                $data['mensaje'] =  $mensaje;
                $data['idioma'] = $this->idioma;
                return view('pages-error', $data);
            }

        } else {
            
            Log::error('ERROR ENVIO DE DATOS');  

            // if is POST
            $mensaje = array(
                'es' => "Error con los datos de la encuesta",
                'en' => "Error with the survey data",
                'br' => "Erro com os dados da pesquisa",
                'pt' => "Erro com os dados da pesquisa",
            );
            $data['mensaje'] =  $mensaje;
            $data['idioma'] = $this->idioma;


            return view('pages-error', $data);
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Encuesta  $encuesta
     * @return \Illuminate\Http\Response
     */
    public function show(Encuesta $encuesta)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Encuesta  $encuesta
     * @return \Illuminate\Http\Response
     */
    public function edit(Encuesta $encuesta)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdateEncuestaRequest  $request
     * @param  \App\Models\Encuesta  $encuesta
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateEncuestaRequest $request, Encuesta $encuesta)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Encuesta  $encuesta
     * @return \Illuminate\Http\Response
     */
    public function destroy(Encuesta $encuesta)
    {
        //
    }
}
