<?php

namespace App\Http\Controllers;

use App\SendMail\SendMail;
use Illuminate\Http\Request;
use App\Models\Delegaciones;
use App\Models\DelegacionesOrder;

class RevisionController extends Controller
{
    /*
    protected $wsdl         = "https://webservices.elcorteingles.es/multiseginternetws/services/OperacionesSeguros?wsdl";
    protected $localCert    = "D:\\inetpub\\wwwroot\\CANDAMENA\\Web\\site\\certificado\\ACCESO_SEGUROS_PRO.pem";
    protected $password     = 'SEGUROS_ACCESO';

    
    protected $wsdl_ap          = 'https://webservices.elcorteingles.es/areaprivadaws/AreaPrivadaService?wsdl';

    */


    /*Configuracion en Desarrollo PRE*/
    
    protected $wsdl_ap          = 'https://webservices.ave.elcorteingles.es/areaprivadaws/AreaPrivadaService?wsdl';




    protected $wsdl          = 'https://webservices.ave.elcorteingles.es:443/multiseginternetws/services/OperacionesSeguros?wsdl';
    //protected $wsdl          = 'https://webservices.nft.elcorteingles.es:443/multiseginternetws/services/OperacionesSeguros?wsdl';
    protected $password      = 'SEGUROSACCESO';
    
    protected $localCert     = "\\\\10.38.4.123\cees_nas\inetpub\wwwroot\CANDAMENA\web\site\certificado\acceso_seguros.pem";
    
    protected $codparnet = 'GESTYDE';
    protected $partnerpassword = '12345678';
    protected $numTransa = 'TSA6000000';


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function revision(Request $request)
    {
        $data = request()->except('_token');
        if(!empty($data['IDCLIENTE']) && !empty($data['POLIZA']) ){
            return view('revision.index');
        } else {
            return view('pages-404');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function sendMail(Request $request)
    {

        $fields = [
			'telefono' => 'required|integer',
        ];

        $message = [
            'required' => ':attribute is required'
        ];

        $this->validate($request, $fields, $message);

        $data = request()->except('_token');

        $delegacionesModel = new Delegaciones();
        $delegacionesOrderModel = new DelegacionesOrder();

        $delegacionesArray = $delegacionesModel->getDelegacionesArray();

        $LengthDelegaciones = count($delegacionesArray) - 1;

        $delegacionesOrderArray = $delegacionesOrderModel->getDelegacionesOrder();

        if (count($delegacionesOrderArray) == 0 || $LengthDelegaciones == $delegacionesOrderArray[0]['position']) {
            $positionSave = 0;
        } else {
            $positionSave = $delegacionesOrderArray[0]['position'] + 1;
        }

        if (count($delegacionesOrderArray) == 0) {
            $delegacionesOrderModel->insertDelegacionesOrder($positionSave);
        } else {
            $delegacionesOrderModel->insertDelegacionesOrder($positionSave);
        }

        $peticion = '';
        if(isset($data['peticion_reformas'])){
            $peticion .= 'Cliente con reformas y desea actualizar datos<br>';
        }
        if(isset($data['peticion_coberturas'])){
            $peticion .= 'Cliente revisar sus coberturas<br>';
        }
        if(isset($data['peticion_otros'])){
            $peticion .= 'Cliente tiene otra petición<br>';
        }

        //$codigo_encriptado = openssl_encrypt('71949093','AES-256-CBC','abcdefqwertyuiopabcdefqwertyuiop',  0, 'abcdefqwertyuiop');


        $idcliente = openssl_decrypt($data['idcliente'],'AES-256-CBC','abcdefqwertyuiopabcdefqwertyuiop',  0, 'abcdefqwertyuiop');
        
        $resultado = $this->callWs($idcliente);
        
        //$resultado = $this->callWs2($idcliente);
        

        if(empty($resultado->error)){

            $objectEmail = (object)[
                'sender' => 'internet@centrodeseguros.com',
                'peticion' => $peticion,
                'telefono' => $data['telefono'],
                'otros' => isset($data['otros']) ? $data['otros'] : 'NO',
                'morning' => isset($data['call_morning']) ? 'SI' : 'NO',
                'afternoon' => isset($data['call_afternoon']) ? 'SI' : 'NO',
                
                'dni' => $resultado->numdocum,
                'contrato' => $data['poliza'],
                'correo' => $resultado->xdirmail,
                //'dni' => $data['dni'],
                //'contrato' => $data['contrato'],
                //'correo' => $data['correo'],
            ];		

            //$to = $delegacionesArray[$positionSave]['delegaciones_email'];
            $to = 'mcsabater@gestyde.com';

            $sendmail = new SendMail();
            $sendmail->sendMailRevision($to, [], $objectEmail);     

            return view('revision.thankyou')->with('name', 'Cliente');
        } else {
            return view('dudas.error')->with('error', $resultado->error);
        }
    }


    public function callWs($idcliente){

        // IDCLIENTE VALIDO NFT
        //$idcliente = '71949093';


        $client = $this->init_ws_cess();
        
        $servicio = 'BuscarDatosClienteCodigo';        
        
        $xmlstr = "<?xml version='1.0' standalone='yes'?><peticion></peticion>";

        $data['numeroIP'] = $this->getIp();
        $data['codparnet'] = $this->codparnet;
        $data['password'] = $this->partnerpassword;
        $data['numtransa'] = $this->numTransa;
        $data['cliente'] = $idcliente;
		
                        
        $peticion = new \SimpleXMLElement($xmlstr);
        $consulta = $peticion->addChild('consulta');
        
        foreach($data as $clave=>$valor){
            $consulta->addChild($clave, $valor);
        }

        $service_param['cadena'] = $peticion->asXML();
		
		if($client != false){
			try {
                /*
                echo "<br>parametros enviados<br>";
                print_r($service_param);
                echo "<br><br>";*/
				$result = $client->__soapCall($servicio, array($service_param));
				
			} catch (SoapFault $exception) {
				return  array( 'error' => $exception->faultstring . '<BR><BR>' . $client->__getLastRequest());
			}
			
			if(isset($result)){
                /*
                print_r(array( 'peticiones' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse()));
			    print_r($result);
                */
				$resultado = new \SimpleXMLElement($result->BuscarDatosClienteCodigoReturn);
				//<respuesta><numtransa>TSA6000000</numtransa><coderror>0</coderror><deserror></deserror></respuesta>
				$codError = (string) $resultado->coderror;
							
				if($codError == 0){
				    return $resultado;
				} else {
					return  array( 'error' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse());
				}
			} else { 
				return  array( 'error' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse());				
			}
		} else {
			return  array( 'error' =>  "Error en inicio de servicio - init_ws_cess");			
		}
    }


    public function init_ws_cess(){
        $clientOptions = array(
			"local_cert" => $this->localCert,
			"passphrase" => $this->password,
			"soap_version" => 'SOAP_1_1',
			"encoding" => "UTF-8",
			"trace" => true,
			"exceptions" => true
		);			
        try {
            $client = new \SoapClient($this->wsdl, $clientOptions);
			return $client;
        } catch (Exception $e) {
			return false;
        }
    }

    /*

    public function callWs2($idcliente){

        // ID CLIENTE NFT 
        $idcliente = '71949093';


        $client = $this->init_ws_cess2();
        
        $servicio = 'activarMarcaDigital';        
        
        $data['nifCliente'] = '';
        $data['nombreCliente'] = '';
        $data['primerApellido'] = '';
        $data['segundoApellido'] = '';
        $data['email'] = '';
        $data['fechConf'] = '';
        $data['horaConf'] = '';
        $data['tipMarca'] = 'NN';
        $data['codCliente'] = $idcliente;
		
        $service_param['peticion'] =  $data;
        		
		if($client != false){
			try {

				//$result = $client->activarMarcaDigital($service_param);

				$result = $client->__soapCall($servicio, array($service_param));
                
				
			} catch (SoapFault $exception) {
				return  array( 'error' => $exception->faultstring . '<BR><BR>' . $client->__getLastRequest());
			}
			if(isset($result)){
                print_r(array( 'peticiones' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse()));
                
				$codResponse = (string) $result->return->response;
							
				if($codResponse == "NN correcta."){
				    return $codResponse;
				} else {
					return  array( 'error' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse());
				}
			} else { 
				return  array( 'error' =>  $client->__getLastRequest() . '<BR><BR>' . $client->__getLastResponse());				
			}
		} else {
			return  array( 'error' =>  "Error en inicio de servicio - init_ws_cess");			
		}
    }


   
    public function init_ws_cess2(){
        $clientOptions = array(
			"local_cert" => $this->localCert,
			"passphrase" => $this->password,
			"soap_version" => SOAP_1_1,
			"encoding" => "UTF-8",
			"trace" => true,
			"exceptions" => true
		);	

        try {
            $client = new \SoapClient($this->wsdl_ap, $clientOptions);

            print_r($client->__getFunctions());

			return $client;
        } catch (Exception $e) {
			return false;
        }
    }

    */
    public function getIp(){
        foreach (array('HTTP_CLIENT_IP', 'HTTP_X_FORWARDED_FOR', 'HTTP_X_FORWARDED', 'HTTP_X_CLUSTER_CLIENT_IP', 'HTTP_FORWARDED_FOR', 'HTTP_FORWARDED', 'REMOTE_ADDR') as $key){
            if (array_key_exists($key, $_SERVER) === true){
                foreach (explode(',', $_SERVER[$key]) as $ip){
                    $ip = trim($ip); // just to be safe
                    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false){
                        return $ip;
                    }
                }
            }
        }
        return request()->ip(); // it will return server ip when no client ip found
    }

}

