<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Encuesta extends Model
{
    use HasFactory;
    
    protected $table = 'encuestas';

    public function getEncuesta($tipo_encuesta)
    {
        $result = Encuesta::select(array(
            'encuestas.titulo',
            'encuestas.intro',
            'encuestas.id_encuesta',
        ))
        ->where('nombre', $tipo_encuesta)
        ->where('activo', 1)
        ->first();
        $result = $result ? $result->toArray() : array();
        return $result;
    }  
    public function getEncuestabyId($id_encuesta)
    {
        $result = Encuesta::select(array(
            'encuestas.nombre',
            'encuestas.titulo',
            'encuestas.intro',
            'encuestas.id_encuesta',
        ))
        ->where('id_encuesta', $id_encuesta)
        ->where('activo', 1)
        ->first();
        $result = $result ? $result->toArray() : array();
        return $result;
    }  


}
