<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EncuestasPreguntas extends Model
{
    use HasFactory;

    
    protected $table = 'encuestas_preguntas';

    public function getEncuestasPreguntasOpciones($id_encuesta)
    {
        $result = EncuestasPreguntas::select(array(
            'encuestas_preguntas.id_encuesta_pregunta',
            'preguntas.texto',
            'preguntas.tipo_respuesta',
            'respuestas.valor',
            'respuestas.id_respuesta',
        ))        
        ->join('preguntas', 'preguntas.id_pregunta', '=', 'encuestas_preguntas.id_pregunta')
        ->leftJoin('respuestas', 'respuestas.id_pregunta', '=', 'preguntas.id_pregunta')
        ->where('id_encuesta', $id_encuesta)
        ->orderBy('encuestas_preguntas.orden', 'asc')
        ->get();
        $result = $result ? $result->toArray() : array();
        return $result;
    }


    public function getEncuestasPreguntas($id_encuesta)
    {
        $result = EncuestasPreguntas::select(array(
            'encuestas_preguntas.id_encuesta_pregunta',
            'preguntas.texto',
            'preguntas.tipo_respuesta',
        ))        
        ->join('preguntas', 'preguntas.id_pregunta', '=', 'encuestas_preguntas.id_pregunta')
        ->where('id_encuesta', $id_encuesta)
        ->orderBy('encuestas_preguntas.orden', 'asc')
        ->get();
        $result = $result ? $result->toArray() : array();
        return $result;
    }

    public function getEncuestasPreguntasObligatorias($id_encuesta)
    {
        $result = EncuestasPreguntas::select(array(
            'encuestas_preguntas.id_encuesta_pregunta',
            'preguntas.texto',
            'preguntas.tipo_respuesta',
        ))        
        ->join('preguntas', 'preguntas.id_pregunta', '=', 'encuestas_preguntas.id_pregunta')
        ->where('encuestas_preguntas.id_encuesta', $id_encuesta)
        ->whereNotIn('preguntas.tipo_respuesta',['cabecera', 'separador', 'comentario'])
        ->orderBy('encuestas_preguntas.orden', 'asc')
        ->get();
        $result = $result ? $result->toArray() : array();
        return $result;
    }


    public function getEncuestasPreguntasRespuestas($id_encuesta, $id_encuesta_proyecto)
    {
        $result = EncuestasPreguntas::select(array(
            'encuestas_preguntas.id_encuesta_pregunta',
            'preguntas.texto',
            'preguntas.tipo_respuesta',
            'preguntas.tipo_respuesta',
            'respuestas.valor',
            'respuestas.id_respuesta',
            'encuestas_respuestas.respuesta',
        ))        
        ->join('preguntas', 'preguntas.id_pregunta', '=', 'encuestas_preguntas.id_pregunta')
        ->leftJoin('respuestas', 'respuestas.id_pregunta', '=', 'preguntas.id_pregunta')
        ->leftJoin('encuestas_respuestas', function($join) use ($id_encuesta_proyecto){
            $join->on('encuestas_respuestas.id_encuesta_pregunta', 'encuestas_preguntas.id_encuesta_pregunta')
                 ->where('encuestas_respuestas.id_encuesta_proyecto', $id_encuesta_proyecto);
        })
        ->where('encuestas_preguntas.id_encuesta', $id_encuesta)
        ->orderBy('encuestas_preguntas.orden', 'asc')
        ->get();
        /*
        ->toSql();
        echo $result;
        die();*/

        $result = $result ? $result->toArray() : array();
        return $result;
    }
}
