<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EncuestasRespuestas extends Model
{
    use HasFactory;

    protected $table = 'encuestas_respuestas';

    public function getEncuestasRespuestas($id_encuesta_proyecto)
    {
        $result = EncuestasRespuestas::select(array(
            'encuestas_preguntas.id_encuesta_pregunta',
            'preguntas.texto',
            'preguntas.tipo_respuesta',
            'preguntas.tipo_respuesta',
            'respuestas.valor',
            'respuestas.id_respuesta',
            'encuestas_respuestas.respuesta'
        ))        
        ->rightJoin('encuestas_preguntas', 'encuestas_preguntas.id_encuesta_pregunta', '=', 'encuestas_respuestas.id_encuesta_pregunta')
        ->join('preguntas', 'preguntas.id_pregunta', '=', 'encuestas_preguntas.id_pregunta')
        ->leftJoin('respuestas', 'respuestas.id_pregunta', '=', 'preguntas.id_pregunta')
        ->where('encuestas_respuestas.id_encuesta_proyecto', $id_encuesta_proyecto)
        ->orderBy('encuestas_preguntas.orden', 'asc')
        ->get();
        $result = $result ? $result->toArray() : array();
        return $result;
    }

    public function insertEncuestasRespuestas($data)
    {
        return EncuestasRespuestas::insert($data);
    }


}
