// Hello world module.
define(['jquery', 'core/ajax', 'core/templates', 'core/notification'], function($, ajax, templates, notification) {

    return {

        refresh: function() {

            $('#button-usuario').on('click', function(){
              var estudiante_id = $( "#estudiante-tool-complete option:selected" ).val();

              var promises = ajax.call([{
                methodname:'tool_complete_hello_world',
                args: {'id':estudiante_id}
              }]);
              promises[0].done(function(data) {

                  for (var i = 0, len = data.length; i< len; i++){
                    $("#cursos-tool-complete").append(
                      $('<option>', {
                          value: data[i].id,
                          text: data[i].fullname
                      })
                    );
                  }

              }).fail(function(ex) {
                  alert(ex.message);
               });
            });

            $('#button-curso').on('click', function(){
              var curso_id = $( "#cursos-tool-complete option:selected" ).val();

              var promises = ajax.call([{
                methodname:'tool_complete_get_activities',
                args: {'id':curso_id}
              }]);
              promises[0].done(function(data) {

                  for (var i = 0, len = data.length; i< len; i++){
                    $("#actividades-tool-complete").append(
                      $('<option>', {
                          value: data[i].id,
                          text: data[i].name
                      })
                    );
                  }

              }).fail(function(ex) {
                  alert(ex.message);
               });
            });

            $('#button-submit').on('click', function(){
              var user_id = $("#estudiante-tool-complete option:selected" ).val();
              var activities_id = $("#actividades-tool-complete option:selected" ).val();

              if (user_id == null || activities_id == null) return;

              var promises = ajax.call([{
                methodname:'tool_complete_set_module_completion',
                args: {'coursemoduleid':activities_id, 'userid':user_id}
              }]);
              promises[0].done(function(data) {
                alert(data.message);
              }).fail(function(ex) {
                  alert('Ha habido un error (¿puede que la actividad ya estuviera'+
                  ' completada por el estudiante?)');
               });
            });

        }

    };
});
