<?php

// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * External Web Service Template
 *
 * @package    localwstemplate
 * @copyright  2011 Moodle Pty Ltd (http://moodle.com)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
require_once($CFG->libdir . "/externallib.php");

class tool_complete_external extends external_api {

    /**
     * Returns description of method parameters
     * @return external_function_parameters
     */
    public static function hello_world_parameters() {
        return new external_function_parameters(
                array('id' => new external_value(PARAM_INT, 'id del estudiante'))
        );
    }

    /**
     * Returns welcome message
     * @return string welcome message
     */
    public static function hello_world($id) {
        global $DB,$CFG;
        $user_enrolments = $CFG->prefix.'user_enrolments';
        $enrol = $CFG->prefix.'enrol';
        $course = $CFG->prefix.'course';
        $accessdata = [];

        $sql = "SELECT {$course}.id, {$course}.fullname FROM {$user_enrolments}, {$enrol}, {$course} ".
        "WHERE {$user_enrolments}.enrolid = {$enrol}.id ".
        "AND {$enrol}.courseid = {$course}.id ".
        "AND {$user_enrolments}.userid = :id";
        $params = array('id'=>$id);

        $rs = $DB->get_recordset_sql($sql, $params);
        foreach ($rs as $rd) {
            array_push($accessdata, array('id' => $rd->id, 'fullname' => $rd->fullname));
        }
        $rs->close();

        //Parameter validation
        //REQUIRED
        $params = self::validate_parameters(self::hello_world_parameters(),
                array('id' => $id));

        return $accessdata;
    }

    /**
     * Returns description of method result value
     * @return external_description
     */
    public static function hello_world_returns() {
      return new external_multiple_structure(
          new external_single_structure(
              array(
                  'id'       => new external_value(PARAM_INT, 'course id'),
                  'fullname' => new external_value(PARAM_TEXT, 'full name'),
              )
          )
      );
    }

    /**
     * Returns description of method parameters
     * @return external_function_parameters
     */
    public static function get_activities_parameters() {
        return new external_function_parameters(
                array('id' => new external_value(PARAM_INT, 'id del curso'))
        );
    }

    public static function get_activities($id){
      global $DB,$CFG;
      $accessdata = [];

      //Parameter validation
      //REQUIRED
      $params = self::validate_parameters(self::get_activities_parameters(),
              array('id' => $id));
      $cms = get_fast_modinfo($id)->get_cms();

      foreach ($cms as $c) {
        array_push($accessdata, array('id' => $c->id, 'name' => $c->name));
      }

      return $accessdata;

    }

    /**
     * Returns description of method result value
     * @return external_description
     */
    public static function get_activities_returns() {
      return new external_multiple_structure(
          new external_single_structure(
              array(
                  'id'       => new external_value(PARAM_INT, 'activity id'),
                  'name' => new external_value(PARAM_TEXT, 'name'),
              )
          )
      );
    }

    /**
     * Returns description of method parameters
     * @return external_function_parameters
     */
    public static function set_module_completion_parameters() {
        return new external_function_parameters(
                array('coursemoduleid' => new external_value(PARAM_INT, 'id del modulo'),
                  'userid' => new external_value(PARAM_INT, 'id del usuario')
              )
        );
    }

    public static function set_module_completion($coursemoduleid, $userid){
      global $DB,$CFG;
      $accessdata = [];
      $response = null;

      //Parameter validation
      //REQUIRED
      $params = self::validate_parameters(self::set_module_completion_parameters(),
              array('coursemoduleid' => $coursemoduleid, 'userid' => $userid));

      $result = $DB->get_record('course_modules_completion', array('coursemoduleid'=>$coursemoduleid,'userid' => $userid));

      if (!$result){
        $record = new stdClass();
        $record->coursemoduleid   = $coursemoduleid;
        $record->userid           = $userid;
        $record->completionstate  = 1;
        $record->viewed           = 1;
        $record->timemodified     = time();
        $lastinsertid = $DB->insert_record('course_modules_completion', $record);

        $response = array('error' => 0, 'message' => 'Actividad completada correctamente');

        if (!is_int($lastinsertid)) {
          $response = array('error' => 1, 'message' => 'Ha habido un error (¿puede que la actividad ya estuviera completada por el estudiante?)');
        }
      }
      else{
        if ($result->completionstate == 0){
          $record_update = new stdClass();
          $record_update->id               = $result->id;
          $record_update->coursemoduleid   = $result->coursemoduleid;
          $record_update->userid           = $result->userid;
          $record_update->completionstate  = 1;
          $record_update->viewed           = 1;
          $record_update->timemodified     = time();
          $update = $DB->update_record('course_modules_completion',$record_update);

          if ($update)
            $response = array('error' => 0, 'message' => 'Actividad completada correctamente');
          else
            $response = array('error' => 1, 'message' => 'Ha habido un error al actualizar los datos');
        }
        else{
            $response = array('error' => 0, 'message' => 'No se ha hecho nigun cambio porque este estudiante ya tiene completada esta actividad');
        }
      }

      return $response;

    }

    /**
     * Returns description of method result value
     * @return external_description
     */
    public static function set_module_completion_returns() {
      return new external_single_structure(
          array(
              'error'   => new external_value(PARAM_INT, 'activity id'),
              'message' => new external_value(PARAM_TEXT, 'name'),
          )
      );
    }

}
