<?php
require_once("$CFG->libdir/formslib.php");
require_once ($CFG->dirroot . '/blocks/moodleblock.class.php');

//formulario
class simplehtml_form extends moodleform {
    //Add elements to form
    public function definition() {
        global $CFG;

        $mform = $this->_form; // Don't forget the underscore!
        $users = get_users();
        $user_select = Array();

        foreach ($users as $u) {
          $user_select[$u->id] = $u->lastname.', '.$u->firstname.' ('.$u->email.')';
        }

        $attributes_user = array(
            'id' => 'estudiante-tool-complete'
        );

        $attributes_courses = array(
            'id' => 'cursos-tool-complete'
        );

        $attributes_activities = array(
            'id' => 'actividades-tool-complete'
        );

        $mform->addElement('select', 'user', get_string('user', 'tool_complete'), $user_select,$attributes_user);
        $mform->addElement('button', 'intro', get_string('select', 'tool_complete'), array('id' => 'button-usuario'));
        $mform->addElement('select', 'course', get_string('courses', 'tool_complete'), array(),$attributes_courses);
        $mform->addElement('button', 'intro', get_string('select', 'tool_complete'), array('id' => 'button-curso'));
        $mform->addElement('select', 'activity', get_string('activities', 'tool_complete'), array(),$attributes_activities);
        $mform->addElement('button', 'submit', 'Completar actividad', array('id' => 'button-submit'));

    }
    //Custom validation should be added here
    function validation($data, $files) {
        return array();
    }
}

//bloque de formulario
class block_form extends block_base{
	public function init(){
		$this->title = 'Formulario';
	}

	public function get_content(){

		$this->content = new stdClass();
		$this->content->text = '';

		$mform = new simplehtml_form();

		//Form processing and displaying is done here
		if ($mform->is_cancelled()) {
			//Handle form cancel operation, if cancel button is present on form
		} else if ($fromform = $mform->get_data()) {
      print_r( $fromform);
			//In this case you process validated data. $mform->get_data() returns data posted in form.
		} else {
			// this branch is executed if the form is submitted but the data doesn't validate and the form should be redisplayed
			// or on the first display of the form.

			//displays the form
			$this->content->text = $mform->render();
		}

		return $this->content->text;

	}
}
